------------------------------------------------------------------------------
--	FILE:	 GreatestEarthMap.lua
--  by djvandyke
--  Imported to Civ VI by Gedemon (2016)
------------------------------------------------------------------------------

include "MapEnums"
include "MapUtilities"
include "MountainsCliffs"
include "RiversLakes"
include "FeatureGenerator"
include "TerrainGenerator"
include "NaturalWonderGenerator"
include "ResourceGenerator"
include "AssignStartingPlots"

local mapName = MapConfiguration.GetValue("MapName")
print("Loading "..tostring(mapName).." script")

local g_iW = 104
local g_iH = 64
local g_iFlags = {};
local g_continentsFrac = nil;

------------------------------------------------------------------------------
-- The application side will call GetMapScriptInfo directly to request
-- information about the map script.
-------------------------------------------------------------------------------
function GetMapInitData(worldSize)
	return {
		Width = g_iW,
		Height = g_iH,
		WrapX = true,
		WrapY = false,
	};      
end

-------------------------------------------------------------------------------
function GenerateMap()
	print("Calling Map Generator");
	-- Everything has been moved to the modded AssignStartingPlots in the "override" folder, search for "YnAMP" string in that file
	GenerateImportedMap(GetMap(), GetCiv6DataToConvert(), GetNaturalWonders(), g_iW, g_iH)
	
	-- Handle Nile delta flow direction (North)
	for x = 56, 60 do
		for y = 33, 37 do
			local plot = Map.GetPlot(x,y)
			if plot then
				MakeRiverFlowToNorth(plot)			
			end
		end
	end
	
	-- Handle source of the Nile flow direction	
	for x = 60, 61 do
		for y = 22, 23 do
			local plot = Map.GetPlot(x,y)
			if plot then
				MakeRiverFlowToNorth(plot)			
			end
		end
	end
	
end

function GetNaturalWonders()
	local NaturalWonders = {}
	
	NaturalWonders[GameInfo.Features["FEATURE_BARRIER_REEF"].Index] 	= { X = 103, Y = 16}	
	NaturalWonders[GameInfo.Features["FEATURE_CLIFFS_DOVER"].Index] 	= { X = 39, Y = 51}
	NaturalWonders[GameInfo.Features["FEATURE_CRATER_LAKE"].Index] 		= { X = 3, Y = 48}	
	NaturalWonders[GameInfo.Features["FEATURE_DEAD_SEA"].Index] 		= { X = 63, Y = 37}	
	NaturalWonders[GameInfo.Features["FEATURE_EVEREST"].Index] 			= { X = 78, Y = 42}	
	NaturalWonders[GameInfo.Features["FEATURE_GALAPAGOS"].Index] 		= { X = 15, Y = 20}
	NaturalWonders[GameInfo.Features["FEATURE_KILIMANJARO"].Index] 		= { X = 62, Y = 17}	
	NaturalWonders[GameInfo.Features["FEATURE_PANTANAL"].Index] 		= { X = 27, Y = 16}	
	NaturalWonders[GameInfo.Features["FEATURE_PIOPIOTAHI"].Index] 		= { X = 0, Y = 6}
	NaturalWonders[GameInfo.Features["FEATURE_TORRES_DEL_PAINE"].Index] = { X = 25, Y = 6}
	NaturalWonders[GameInfo.Features["FEATURE_TSINGY"].Index] 			= { X = 64, Y = 9}
	NaturalWonders[GameInfo.Features["FEATURE_YOSEMITE"].Index] 		= { X = 2, Y = 45}
	
	return NaturalWonders
end

function GetCiv6DataToConvert()
	-- Map data was exported from Civ6 WB, cliffs are included in MapToConvert
	return {}
end

function GetMap()

	local MapToConvert = {}
	for i = 0, g_iW - 1, 1 do
		MapToConvert[i] = {}
	end
	
	-- Map Data (from Civ6 WB)
	-- MapToConvert[x][y] = {civ6TerrainType, civ6FeatureTypes, civ6ContinentType, {{IsNEOfRiver, flow}, {IsWOfRiver, flow}, {IsNWOfRiver, flow}}, {Civ6ResourceType, num}, {IsNEOfCliff, IsWOfCliff, IsNWOfCliff} }

 MapToConvert[0][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[16][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[42][0]={12,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][0]={13,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][0]={13,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][0]={12,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][0]={12,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[47][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][0]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[6][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[25][1]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[26][1]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[27][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[31][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[34][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[35][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[42][1]={12,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][1]={12,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][1]={12,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][1]={12,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[77][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[78][1]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][1]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][1]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][1]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][1]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][1]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][1]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[85][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[86][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[8][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[9][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][2]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][2]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[13][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[14][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][2]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[26][2]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[35][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[44][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[45][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][2]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][2]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][2]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][2]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][2]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][2]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[24][3]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[25][3]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][3]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[27][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[30][3]={10,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][3]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[32][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[54][3]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[55][3]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][3]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][3]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[81][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[82][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[25][4]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][4]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][4]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[28][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[31][4]={4,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][4]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[33][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][4]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[55][4]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][4]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][4]={1,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][4]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[59][4]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[60][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][5]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][5]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][5]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][5]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][5]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[31][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][5]={6,0,0,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[54][5]={6,0,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[55][5]={3,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[56][5]={3,3,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[57][5]={2,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[58][5]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][5]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][5]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[103][5]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[0][6]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][6]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][6]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][6]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][6]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][6]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[53][6]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][6]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][6]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][6]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][6]={1,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][6]={5,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][6]={4,3,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[60][6]={3,3,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[65][6]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[66][6]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][7]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][7]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][7]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][7]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][7]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][7]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[28][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][7]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[53][7]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][7]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][7]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][7]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][7]={0,3,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[58][7]={3,-1,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][7]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][7]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[65][7]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][7]={1,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[67][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][7]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[101][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][8]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[2][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[25][8]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][8]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][8]={1,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][8]={0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[29][8]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][8]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][8]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][8]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][8]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][8]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][8]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][8]={4,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][8]={0,3,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][8]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][8]={0,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[66][8]={2,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][8]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][8]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[71][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[100][8]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][8]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[2][9]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][9]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[4][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][9]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[26][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][9]={0,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[28][9]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][9]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][9]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][9]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][9]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][9]={3,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][9]={0,3,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[57][9]={0,-1,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[58][9]={0,-1,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[59][9]={1,-1,0,{{1,2},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[60][9]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][9]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][9]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][9]={3,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][9]={4,2,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[67][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][9]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[73][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[100][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[101][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[3][10]={1,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[4][10]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[5][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][10]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][10]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[27][10]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][10]={0,3,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[29][10]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][10]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[31][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[53][10]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][10]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][10]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][10]={3,-1,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[57][10]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][10]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][10]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][10]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][10]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[62][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[65][10]={0,-1,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][10]={4,2,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][10]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[68][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][10]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[94][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][10]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][10]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][10]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[102][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][11]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[3][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][11]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][11]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][11]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][11]={0,3,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[29][11]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][11]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[53][11]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][11]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][11]={3,3,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][11]={0,3,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][11]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][11]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][11]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][11]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][11]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[62][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[65][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][11]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][11]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][11]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][11]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][11]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][11]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[97][11]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[98][11]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][11]={3,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[100][11]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][11]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[4][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][12]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][12]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][12]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][12]={0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][12]={1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][12]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[32][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][12]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][12]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][12]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][12]={4,3,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][12]={1,3,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][12]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][12]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][12]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][12]={1,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][12]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][12]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[67][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[68][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[92][12]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[93][12]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][12]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][12]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][12]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][12]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][12]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][12]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][12]={3,3,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[101][12]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][12]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][13]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[24][13]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[25][13]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][13]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][13]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][13]={3,2,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[29][13]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[30][13]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[31][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[51][13]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][13]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][13]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][13]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][13]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][13]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][13]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][13]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][13]={1,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][13]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][13]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[70][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][13]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][13]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][13]={8,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][13]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][13]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][13]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][13]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][13]={8,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[99][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][13]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][13]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][13]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][14]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][14]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[26][14]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][14]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][14]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][14]={1,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[30][14]={2,-1,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[31][14]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][14]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[33][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[52][14]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][14]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][14]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][14]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][14]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][14]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][14]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[59][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][14]={0,5,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][14]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][14]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][14]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][14]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][14]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][14]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][14]={8,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[100][14]={3,3,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[101][14]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][14]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][15]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][15]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][15]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][15]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[25][15]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[26][15]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][15]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][15]={4,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][15]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][15]={4,-1,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[31][15]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][15]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[51][15]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[52][15]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][15]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][15]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][15]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][15]={3,2,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][15]={2,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[58][15]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[59][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[60][15]={4,2,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[61][15]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][15]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[63][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[92][15]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][15]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][15]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][15]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][15]={0,3,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[101][15]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][16]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[4][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[21][16]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[22][16]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][16]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][16]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][16]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][16]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][16]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][16]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][16]={0,5,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[30][16]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][16]={4,3,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[32][16]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][16]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[52][16]={3,2,0,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[53][16]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][16]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][16]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][16]={3,2,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][16]={4,2,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[59][16]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][16]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][16]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][16]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][16]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][16]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[93][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][16]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][16]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][16]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][16]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][17]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][17]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][17]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][17]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][17]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][17]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][17]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][17]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][17]={4,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][17]={0,5,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][17]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][17]={4,-1,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[32][17]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][17]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[34][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][17]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][17]={4,2,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[53][17]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][17]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][17]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][17]={4,2,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[57][17]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][17]={4,2,0,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[59][17]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][17]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][17]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][17]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[64][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[65][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[66][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[94][17]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][17]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][17]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[97][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][17]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][17]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[20][18]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][18]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][18]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][18]={11,-1,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[24][18]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][18]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][18]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][18]={3,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][18]={4,2,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][18]={0,5,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[30][18]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][18]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][18]={3,-1,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[33][18]={3,2,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][18]={0,5,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[35][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][18]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][18]={3,2,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[54][18]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][18]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][18]={3,2,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][18]={2,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[58][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][18]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][18]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][18]={4,2,0,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[63][18]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][18]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[65][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[95][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[96][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[98][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[100][18]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][19]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[20][19]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][19]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][19]={11,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][19]={1,-1,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][19]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][19]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][19]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][19]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[28][19]={3,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][19]={3,2,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][19]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][19]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][19]={4,3,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[33][19]={4,2,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][19]={0,5,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][19]={0,5,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][19]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][19]={4,2,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[54][19]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][19]={3,2,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][19]={3,2,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][19]={2,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[58][19]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][19]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][19]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[61][19]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[62][19]={4,2,0,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[63][19]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][19]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[100][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[4][20]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[5][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[18][20]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[19][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][20]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][20]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][20]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][20]={1,-1,2,{{0,-1},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[24][20]={0,5,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[25][20]={0,5,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[26][20]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][20]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][20]={0,5,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[29][20]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[30][20]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][20]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][20]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][20]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[34][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[43][20]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][20]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][20]={0,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][20]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[47][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][20]={0,5,0,{{0,-1},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[51][20]={3,2,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][20]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][20]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][20]={4,2,0,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[55][20]={3,2,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[56][20]={3,2,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][20]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][20]={2,-1,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[59][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][20]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][20]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][20]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][20]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][20]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][20]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[66][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][21]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][21]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][21]={1,-1,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[21][21]={1,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[22][21]={1,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[23][21]={1,-1,2,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][21]={3,2,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[25][21]={3,2,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[26][21]={0,5,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[27][21]={3,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][21]={3,2,2,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][21]={0,5,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][21]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][21]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[33][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[34][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][21]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][21]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[43][21]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][21]={3,2,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][21]={0,5,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][21]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][21]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[49][21]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[50][21]={3,2,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[51][21]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][21]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][21]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][21]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][21]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][21]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][21]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][21]={1,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][21]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[61][21]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][21]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][21]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][21]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[66][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[3][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[4][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[20][22]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][22]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][22]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][22]={0,5,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[24][22]={0,5,2,{{1,2},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][22]={2,-1,2,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[26][22]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][22]={3,2,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[28][22]={2,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[29][22]={3,2,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[30][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[31][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[32][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][22]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[41][22]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][22]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][22]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][22]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][22]={4,2,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][22]={4,2,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][22]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][22]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][22]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][22]={3,2,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][22]={0,-1,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][22]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][22]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][22]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][22]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][22]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][22]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][22]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][22]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[60][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][22]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][22]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][22]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][22]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][22]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][22]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[98][22]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[99][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][22]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[101][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[21][23]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][23]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][23]={0,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][23]={2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][23]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][23]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][23]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][23]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[29][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][23]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][23]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][23]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][23]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][23]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][23]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][23]={0,-1,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[46][23]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][23]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][23]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][23]={0,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][23]={0,-1,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][23]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][23]={1,-1,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][23]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][23]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][23]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][23]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][23]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][23]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][23]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[60][23]={0,-1,0,{{0,-1},{1,0},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[61][23]={1,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][23]={1,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][23]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][23]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][23]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][23]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][23]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[94][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[95][23]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][23]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][23]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][23]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][23]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][24]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[22][24]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][24]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][24]={3,2,2,{{0,-1},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[25][24]={0,5,2,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[26][24]={0,5,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[27][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[30][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[39][24]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[40][24]={3,-1,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][24]={4,-1,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][24]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][24]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][24]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][24]={4,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][24]={4,-1,0,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[47][24]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][24]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][24]={3,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][24]={3,-1,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][24]={0,5,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][24]={0,5,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][24]={3,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][24]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][24]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][24]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][24]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][24]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][24]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][24]={0,3,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[61][24]={0,3,0,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[62][24]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][24]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][24]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][24]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][24]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][24]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[68][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[85][24]={1,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[86][24]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][24]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][24]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[90][24]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][24]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[93][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][24]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[96][24]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][24]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][24]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[99][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[100][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][25]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][25]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[21][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][25]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][25]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[28][25]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[29][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[39][25]={3,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[40][25]={3,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][25]={3,-1,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[42][25]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][25]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][25]={4,-1,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[45][25]={3,-1,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][25]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][25]={3,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][25]={3,-1,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[49][25]={3,-1,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][25]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][25]={6,0,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][25]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][25]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][25]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][25]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][25]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][25]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][25]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][25]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][25]={1,3,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[62][25]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][25]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][25]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][25]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][25]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][25]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[68][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][25]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[87][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[93][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][25]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[97][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[98][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][26]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[20][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[21][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[22][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[23][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[26][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[29][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[30][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][26]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][26]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][26]={3,-1,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[43][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][26]={3,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][26]={3,-1,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[48][26]={3,-1,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][26]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[52][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[53][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][26]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][26]={4,-1,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[61][26]={1,-1,0,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[62][26]={2,-1,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[63][26]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][26]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][26]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[69][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][26]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[87][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[88][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][26]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[95][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[96][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][27]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[19][27]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][27]={0,5,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[38][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][27]={6,0,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[43][27]={6,0,0,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[44][27]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][27]={6,0,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][27]={6,0,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[52][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[53][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][27]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][27]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][27]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][27]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][27]={3,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][27]={0,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[62][27]={5,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][27]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][27]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][27]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][27]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][27]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][27]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[69][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][27]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[92][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[93][27]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[95][27]={0,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[96][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][28]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][28]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[39][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][28]={6,-1,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[45][28]={7,-1,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[46][28]={6,-1,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][28]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][28]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][28]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][28]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][28]={3,-1,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][28]={3,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][28]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][28]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][28]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[66][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[68][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[69][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[70][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[78][28]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[84][28]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[85][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][28]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[88][28]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[89][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][28]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[93][28]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[96][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[97][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][29]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][29]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][29]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][29]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][29]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][29]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][29]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][29]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][29]={6,-1,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][29]={7,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][29]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][29]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][29]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[65][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,0}}
 MapToConvert[66][29]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[67][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][29]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[78][29]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][29]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][29]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[84][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[86][29]={3,2,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[87][29]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][29]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][29]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][29]={0,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[2][30]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[3][30]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][30]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][30]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][30]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[17][30]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[18][30]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][30]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[20][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[21][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][30]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[31][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][30]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][30]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][30]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][30]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][30]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][30]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][30]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][30]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][30]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][30]={6,0,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[61][30]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][30]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][30]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][30]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][30]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][30]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[69][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][30]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[79][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[80][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[82][30]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][30]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[87][30]={3,2,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[88][30]={4,2,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][31]={4,3,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][31]={2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[3][31]={1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[4][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][31]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][31]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][31]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][31]={3,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][31]={0,-1,2,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[17][31]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][31]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[20][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[30][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[31][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][31]={3,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[40][31]={3,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[41][31]={3,-1,0,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[42][31]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][31]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][31]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][31]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][31]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][31]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][31]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][31]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][31]={6,0,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][31]={6,0,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[60][31]={6,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[63][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][31]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][31]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[70][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][31]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[82][31]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][31]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[89][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][32]={4,3,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][32]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[11][32]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[12][32]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][32]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][32]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][32]={0,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][32]={0,5,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][32]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][32]={0,5,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][32]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[25][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][32]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[30][32]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[31][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[40][32]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][32]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][32]={8,-1,0,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[43][32]={8,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][32]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][32]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][32]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][32]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][32]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][32]={6,0,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][32]={6,0,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][32]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][32]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[63][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[64][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][32]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][32]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][32]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[72][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][32]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][32]={0,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[78][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][32]={1,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[91][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[1][33]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[2][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][33]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[11][33]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][33]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[13][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[14][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][33]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][33]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][33]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][33]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[26][33]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][33]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][33]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[38][33]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][33]={3,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[41][33]={4,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[42][33]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][33]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][33]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][33]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][33]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][33]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][33]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][33]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][33]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][33]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][33]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][33]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][33]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][33]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][33]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][33]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][33]={6,0,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[59][33]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][33]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][33]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][33]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][33]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][33]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][33]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][33]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][33]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][33]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[72][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[75][33]={0,5,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][33]={2,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][33]={0,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[78][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][33]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[87][33]={1,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][33]={1,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[91][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][34]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[1][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[2][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][34]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][34]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][34]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[17][34]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][34]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[19][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[27][34]={4,2,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][34]={0,5,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][34]={3,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][34]={3,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[38][34]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][34]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][34]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][34]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][34]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][34]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][34]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][34]={5,-1,0,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[48][34]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[52][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[53][34]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][34]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][34]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][34]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][34]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][34]={6,0,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][34]={6,0,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][34]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][34]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][34]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][34]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][34]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][34]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][34]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][34]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][34]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[75][34]={4,2,5,{{0,-1},{1,3},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[76][34]={1,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[77][34]={0,5,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[83][34]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[88][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][34]={1,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[0][35]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[8][35]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][35]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][35]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][35]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[17][35]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][35]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][35]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][35]={4,2,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[28][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][35]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[34][35]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[35][35]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][35]={3,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][35]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][35]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][35]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[40][35]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[42][35]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][35]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][35]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][35]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][35]={3,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][35]={3,3,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[48][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[49][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][35]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][35]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][35]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][35]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][35]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][35]={6,0,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][35]={6,0,0,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[59][35]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][35]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][35]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][35]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][35]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][35]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][35]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][35]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][35]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][35]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][35]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][35]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][35]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[82][35]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[83][35]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[88][35]={1,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][35]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][36]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[9][36]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][36]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][36]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][36]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][36]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][36]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][36]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][36]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[25][36]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[29][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[33][36]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[34][36]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][36]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][36]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][36]={1,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[38][36]={1,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[39][36]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][36]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[43][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[45][36]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][36]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][36]={0,3,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[48][36]={0,3,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][36]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[55][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[57][36]={0,-1,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][36]={0,-1,0,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][36]={0,-1,0,{{1,2},{1,0},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[60][36]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][36]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][36]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][36]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][36]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][36]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][36]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][36]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[69][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[70][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][36]={0,-1,5,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[76][36]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][36]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][36]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[79][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][36]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][36]={0,5,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][36]={0,5,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[89][36]={1,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][36]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][36]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][37]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][37]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][37]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[10][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][37]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[17][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[18][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[21][37]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[22][37]={0,5,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[23][37]={0,5,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][37]={0,-1,17,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[34][37]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][37]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][37]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][37]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][37]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][37]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][37]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[41][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[47][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[51][37]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][37]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][37]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][37]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][37]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][37]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][37]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][37]={0,5,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[74][37]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[75][37]={1,-1,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[76][37]={1,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[77][37]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][37]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][37]={0,5,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[82][37]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][37]={3,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][37]={0,5,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][37]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][37]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][37]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[102][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[5][38]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[6][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][38]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][38]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][38]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][38]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[11][38]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][38]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[22][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[23][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][38]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][38]={1,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[35][38]={1,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[36][38]={0,3,17,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][38]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][38]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][38]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][38]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][38]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][38]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][38]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[51][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[52][38]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][38]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[54][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][38]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][38]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][38]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][38]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][38]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][38]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][38]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][38]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][38]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][38]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[72][38]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][38]={6,0,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[74][38]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][38]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][38]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][38]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][38]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][38]={0,5,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][38]={0,5,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][38]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[82][38]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][38]={3,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][38]={4,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][38]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[86][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[99][38]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[102][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[103][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][39]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,0}}
 MapToConvert[5][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][39]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][39]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][39]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][39]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][39]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][39]={3,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][39]={0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][39]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[33][39]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][39]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][39]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][39]={0,3,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][39]={1,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][39]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][39]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][39]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][39]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][39]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[49][39]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][39]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][39]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][39]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[58][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[59][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][39]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[61][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][39]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][39]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][39]={6,0,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][39]={6,0,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[67][39]={6,0,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][39]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][39]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][39]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][39]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][39]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][39]={6,0,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[74][39]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[75][39]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][39]={0,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[77][39]={0,-1,5,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[78][39]={0,-1,5,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[79][39]={3,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][39]={3,2,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][39]={0,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[82][39]={0,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[83][39]={4,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][39]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[86][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][39]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[99][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][40]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[6][40]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][40]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][40]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][40]={8,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][40]={4,-1,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[11][40]={4,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][40]={1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][40]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][40]={0,5,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[15][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[18][40]={3,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[19][40]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[34][40]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][40]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][40]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][40]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][40]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][40]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][40]={3,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][40]={4,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[42][40]={3,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[47][40]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][40]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[49][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][40]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][40]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][40]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[55][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[56][40]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][40]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[58][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][40]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][40]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][40]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][40]={6,0,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][40]={6,0,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][40]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][40]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][40]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][40]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][40]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][40]={8,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][40]={8,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][40]={0,-1,5,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[75][40]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][40]={0,5,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][40]={0,2,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][40]={3,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][40]={3,2,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[80][40]={3,2,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][40]={0,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][40]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][40]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][40]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][40]={0,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[88][40]={0,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{1,0,0}}
 MapToConvert[89][40]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[90][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][40]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][41]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[5][41]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[6][41]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][41]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][41]={8,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][41]={4,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][41]={4,-1,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[11][41]={3,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][41]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][41]={0,5,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][41]={0,5,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][41]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][41]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][41]={0,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][41]={0,5,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][41]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[34][41]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][41]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][41]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][41]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][41]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][41]={2,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[40][41]={5,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][41]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[47][41]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][41]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[52][41]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][41]={3,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][41]={4,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[63][41]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][41]={3,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][41]={6,0,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][41]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][41]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[69][41]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][41]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][41]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][41]={4,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][41]={0,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][41]={10,3,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[75][41]={10,3,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[76][41]={10,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][41]={10,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][41]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][41]={11,-1,5,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][41]={11,-1,5,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][41]={0,-1,5,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[82][41]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][41]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][41]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[85][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][41]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[90][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[4][42]={7,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][42]={6,0,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][42]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][42]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][42]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][42]={3,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[10][42]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][42]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][42]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][42]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][42]={0,3,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[15][42]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][42]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][42]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][42]={0,5,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[19][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[35][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[37][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][42]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][42]={1,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][42]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][42]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][42]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][42]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][42]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][42]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][42]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[55][42]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[56][42]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][42]={1,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[58][42]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[59][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][42]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[61][42]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[62][42]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][42]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][42]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][42]={4,-1,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[66][42]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][42]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][42]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][42]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][42]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][42]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][42]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][42]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][42]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][42]={13,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[76][42]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][42]={14,-1,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[78][42]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][42]={13,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][42]={11,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][42]={11,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][42]={0,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[83][42]={1,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[84][42]={3,2,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[85][42]={4,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[86][42]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][42]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[92][42]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[93][42]={0,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[94][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][43]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][43]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[4][43]={6,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[5][43]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][43]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][43]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][43]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][43]={3,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[10][43]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][43]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][43]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][43]={1,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][43]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][43]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][43]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][43]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][43]={0,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][43]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][43]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][43]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][43]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][43]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[44][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[47][43]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][43]={1,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[50][43]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[51][43]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[53][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][43]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][43]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][43]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][43]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][43]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][43]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][43]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[64][43]={4,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][43]={4,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][43]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][43]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][43]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][43]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][43]={8,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][43]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][43]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][43]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][43]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][43]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][43]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][43]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][43]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][43]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][43]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][43]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][43]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][43]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][43]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][43]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][43]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][43]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][43]={0,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][43]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[94][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][43]={0,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[96][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][44]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][44]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][44]={8,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][44]={6,0,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][44]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][44]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][44]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][44]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][44]={4,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[11][44]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][44]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][44]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][44]={0,3,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[15][44]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][44]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][44]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][44]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][44]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[20][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][44]={0,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[39][44]={0,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][44]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][44]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][44]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][44]={0,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][44]={3,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][44]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][44]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][44]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][44]={1,3,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[51][44]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][44]={3,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{1,0,0}}
 MapToConvert[55][44]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][44]={4,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][44]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[58][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][44]={3,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[60][44]={4,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][44]={6,0,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[62][44]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][44]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][44]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][44]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][44]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[69][44]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][44]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][44]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][44]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][44]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][44]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][44]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][44]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[77][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][44]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][44]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][44]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][44]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][44]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][44]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][44]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][44]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][44]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][44]={0,3,5,{{0,-1},{0,-1},{1,4}},{-1,1},{1,0,0}}
 MapToConvert[93][44]={0,2,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][44]={0,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][44]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][44]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[1][45]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[2][45]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][45]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][45]={6,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[5][45]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][45]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][45]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][45]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][45]={3,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][45]={3,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][45]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][45]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][45]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][45]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][45]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][45]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][45]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][45]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][45]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][45]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][45]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][45]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][45]={4,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][45]={1,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][45]={4,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[44][45]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][45]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][45]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[47][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[49][45]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][45]={4,3,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[51][45]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[52][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][45]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][45]={3,3,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[55][45]={4,3,17,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[56][45]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][45]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[58][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][45]={3,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][45]={4,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][45]={1,3,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[62][45]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][45]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][45]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][45]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][45]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[69][45]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][45]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][45]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][45]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][45]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][45]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][45]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][45]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[77][45]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[78][45]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][45]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][45]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][45]={11,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[82][45]={4,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[83][45]={1,-1,5,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[84][45]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[85][45]={0,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[86][45]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][45]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][45]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[89][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][45]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][45]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][45]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[99][45]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][46]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][46]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][46]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][46]={6,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[6][46]={6,0,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][46]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][46]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][46]={4,-1,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[10][46]={4,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][46]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][46]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][46]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][46]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][46]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][46]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][46]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][46]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][46]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[21][46]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[22][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][46]={0,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[39][46]={0,-1,17,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[40][46]={0,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][46]={0,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[42][46]={1,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][46]={4,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][46]={0,3,17,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[45][46]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][46]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][46]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][46]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][46]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][46]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][46]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[53][46]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[54][46]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][46]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][46]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][46]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[59][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[60][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[63][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[64][46]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][46]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][46]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[67][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][46]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][46]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][46]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][46]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][46]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][46]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][46]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][46]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][46]={8,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][46]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][46]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][46]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][46]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][46]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][46]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][46]={0,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[85][46]={0,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[86][46]={0,-1,5,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[87][46]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][46]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][46]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[90][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[93][46]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][46]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[95][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][46]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][46]={4,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][46]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[102][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][47]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][47]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][47]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][47]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][47]={6,-1,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[6][47]={7,-1,2,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[7][47]={3,-1,2,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[8][47]={4,-1,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][47]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][47]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][47]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][47]={0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][47]={1,-1,2,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[14][47]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][47]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][47]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][47]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][47]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][47]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][47]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[21][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][47]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[37][47]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][47]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][47]={0,3,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[40][47]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][47]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][47]={4,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][47]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][47]={1,3,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[45][47]={2,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][47]={1,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[47][47]={0,3,17,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[48][47]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[49][47]={3,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[50][47]={3,-1,17,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[51][47]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][47]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][47]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][47]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][47]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][47]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][47]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][47]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][47]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][47]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[67][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][47]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][47]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][47]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][47]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][47]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][47]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][47]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][47]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][47]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][47]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][47]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][47]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][47]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][47]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][47]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][47]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][47]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][47]={0,3,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[87][47]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][47]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][47]={1,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[94][47]={0,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][47]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[96][47]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[97][47]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][47]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][47]={4,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][47]={3,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][48]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][48]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][48]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][48]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][48]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][48]={7,-1,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[8][48]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][48]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][48]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][48]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][48]={0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][48]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][48]={0,-1,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[15][48]={0,3,2,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[16][48]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][48]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][48]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][48]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][48]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][48]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[36][48]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][48]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][48]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][48]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][48]={0,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][48]={0,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[42][48]={0,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[43][48]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][48]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][48]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][48]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][48]={10,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][48]={1,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][48]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][48]={4,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][48]={3,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[52][48]={0,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][48]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][48]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][48]={0,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][48]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[57][48]={1,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[58][48]={1,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[59][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][48]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[62][48]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[63][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[64][48]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][48]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][48]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][48]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[70][48]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][48]={6,0,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][48]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][48]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][48]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][48]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][48]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][48]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][48]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][48]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[81][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[82][48]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][48]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][48]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][48]={0,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[86][48]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][48]={0,3,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[88][48]={0,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[95][48]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][48]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][48]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][48]={0,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][48]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][48]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][49]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][49]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][49]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][49]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[6][49]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][49]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][49]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][49]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][49]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][49]={0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][49]={0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][49]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][49]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][49]={0,3,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[16][49]={0,-1,2,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[17][49]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][49]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][49]={1,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[20][49]={1,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[21][49]={0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][49]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[23][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[34][49]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[35][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[36][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[37][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[38][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[39][49]={0,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][49]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][49]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][49]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][49]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][49]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][49]={1,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][49]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][49]={11,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][49]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][49]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][49]={2,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][49]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][49]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][49]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][49]={0,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][49]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][49]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][49]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][49]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[59][49]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][49]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][49]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][49]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][49]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][49]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][49]={6,0,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][49]={6,0,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][49]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[70][49]={6,0,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][49]={5,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][49]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][49]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][49]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][49]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][49]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][49]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][49]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[80][49]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][49]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][49]={4,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[83][49]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][49]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][49]={0,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[86][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[87][49]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[88][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[89][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][49]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][49]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[93][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][49]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][49]={1,3,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[98][49]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][49]={0,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[100][49]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[2][50]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][50]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][50]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][50]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][50]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[7][50]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][50]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][50]={3,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][50]={0,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[11][50]={0,-1,2,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[12][50]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][50]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][50]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][50]={0,-1,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[18][50]={0,3,2,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[19][50]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][50]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][50]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][50]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][50]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[24][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[35][50]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][50]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][50]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[40][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[42][50]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][50]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][50]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][50]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][50]={1,3,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[47][50]={0,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[48][50]={0,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][50]={0,-1,17,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[50][50]={1,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[51][50]={1,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[52][50]={1,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[53][50]={1,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[54][50]={0,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[55][50]={0,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][50]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][50]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][50]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][50]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][50]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][50]={3,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[62][50]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][50]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][50]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][50]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][50]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][50]={3,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][50]={3,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][50]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][50]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][50]={6,-1,17,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[72][50]={6,0,17,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[73][50]={6,0,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[74][50]={5,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][50]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][50]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][50]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][50]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][50]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][50]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][50]={3,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[82][50]={3,-1,5,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[83][50]={3,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[84][50]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][50]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][50]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[87][50]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[89][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][50]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][50]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[97][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,0}}
 MapToConvert[98][50]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][50]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][50]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][50]={3,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][50]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][51]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][51]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][51]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][51]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][51]={3,3,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][51]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][51]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][51]={1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][51]={0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][51]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][51]={0,3,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[12][51]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[13][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][51]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][51]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][51]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][51]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][51]={0,3,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[19][51]={1,3,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][51]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][51]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][51]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][51]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[39][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{8,1},{1,0,1}}
 MapToConvert[40][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[41][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][51]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][51]={0,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][51]={0,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[46][51]={0,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][51]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][51]={0,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][51]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][51]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][51]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][51]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][51]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][51]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][51]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][51]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][51]={3,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][51]={4,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][51]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][51]={0,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[68][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][51]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][51]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[73][51]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][51]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][51]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][51]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][51]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][51]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][51]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][51]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][51]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][51]={4,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[83][51]={5,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][51]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][51]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][51]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][51]={0,5,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][51]={0,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[92][51]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][51]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[98][51]={0,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][51]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][51]={1,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[101][51]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][52]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][52]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][52]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][52]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][52]={3,3,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[7][52]={1,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[8][52]={0,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[9][52]={0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][52]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][52]={0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][52]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][52]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][52]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][52]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][52]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][52]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][52]={0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[24][52]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[32][52]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[33][52]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[35][52]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][52]={4,3,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][52]={4,-1,17,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[38][52]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][52]={0,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][52]={0,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[41][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[42][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][52]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][52]={0,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][52]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][52]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][52]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][52]={0,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][52]={0,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[50][52]={0,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[51][52]={0,-1,17,{{1,5},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[52][52]={1,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][52]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][52]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][52]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][52]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][52]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][52]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][52]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][52]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][52]={0,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[62][52]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][52]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][52]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][52]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][52]={0,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][52]={0,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[68][52]={0,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][52]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][52]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][52]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][52]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][52]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[74][52]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][52]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][52]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][52]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][52]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][52]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][52]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][52]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][52]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][52]={4,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[84][52]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][52]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][52]={0,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[87][52]={0,-1,5,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[88][52]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[89][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][52]={1,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[93][52]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[99][52]={2,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[100][52]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][52]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[102][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[103][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][53]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][53]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][53]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][53]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][53]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][53]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][53]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][53]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][53]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][53]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][53]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[13][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][53]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][53]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[18][53]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[19][53]={1,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][53]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][53]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][53]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[23][53]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[24][53]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][53]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[26][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[32][53]={3,3,17,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[33][53]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[35][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[36][53]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][53]={0,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][53]={1,3,17,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[39][53]={1,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{6,1},{0,0,0}}
 MapToConvert[41][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][53]={0,5,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][53]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][53]={0,-1,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[49][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][53]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][53]={0,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][53]={0,-1,17,{{1,5},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[53][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][53]={0,-1,17,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[56][53]={0,3,17,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[57][53]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][53]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][53]={0,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][53]={1,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[61][53]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][53]={0,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[67][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][53]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][53]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][53]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][53]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][53]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][53]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[78][53]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][53]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][53]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][53]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][53]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][53]={4,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[84][53]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][53]={0,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][53]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[90][53]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[91][53]={0,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][53]={2,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[93][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[94][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[99][53]={1,3,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][53]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[102][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][54]={0,3,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[3][54]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][54]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][54]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][54]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][54]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][54]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][54]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][54]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][54]={1,3,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[12][54]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][54]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][54]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[15][54]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][54]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[17][54]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[18][54]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][54]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][54]={1,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[21][54]={0,-1,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[22][54]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][54]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][54]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[27][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[32][54]={1,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[33][54]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][54]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[36][54]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][54]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][54]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][54]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][54]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][54]={3,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][54]={4,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[48][54]={0,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[49][54]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][54]={0,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][54]={0,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][54]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][54]={0,3,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[58][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][54]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][54]={0,3,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[61][54]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][54]={0,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][54]={0,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[66][54]={0,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[67][54]={0,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][54]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][54]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][54]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][54]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][54]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][54]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][54]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][54]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][54]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][54]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][54]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][54]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][54]={4,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[85][54]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][54]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][54]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][54]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[89][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][54]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][54]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][54]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[99][54]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][54]={3,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][54]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[1][55]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[2][55]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][55]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][55]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][55]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][55]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][55]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][55]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][55]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][55]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][55]={4,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][55]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[15][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[16][55]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][55]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][55]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][55]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][55]={3,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][55]={4,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,1,0}}
 MapToConvert[22][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[32][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][55]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][55]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[36][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[37][55]={4,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][55]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][55]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[46][55]={0,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][55]={0,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][55]={0,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][55]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][55]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][55]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][55]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][55]={0,3,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[58][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][55]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][55]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][55]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][55]={0,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][55]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][55]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][55]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][55]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][55]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][55]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][55]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][55]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][55]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][55]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][55]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][55]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][55]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][55]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][55]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][55]={0,3,5,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[91][55]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[99][55]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][55]={3,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[101][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][56]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][56]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][56]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][56]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][56]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][56]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][56]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][56]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][56]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][56]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][56]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][56]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][56]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][56]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][56]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][56]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][56]={10,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][56]={10,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][56]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[23][56]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[25][56]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[26][56]={9,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[33][56]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[35][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[36][56]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[37][56]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][56]={1,-1,17,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[39][56]={0,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[40][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][56]={0,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[47][56]={1,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][56]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[51][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[52][56]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][56]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][56]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][56]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][56]={0,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][56]={0,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[58][56]={0,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][56]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][56]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][56]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][56]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][56]={1,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[64][56]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[66][56]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[67][56]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][56]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][56]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][56]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][56]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][56]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][56]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][56]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][56]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][56]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][56]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][56]={8,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][56]={7,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][56]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][56]={7,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][56]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][56]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][56]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][56]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][56]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][56]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[90][56]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][56]={2,-1,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[92][56]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[93][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][56]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][57]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][57]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][57]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][57]={2,-1,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[5][57]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][57]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][57]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][57]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][57]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[11][57]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][57]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][57]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[14][57]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[15][57]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[16][57]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][57]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][57]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][57]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][57]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][57]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][57]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][57]={10,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[26][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[27][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[33][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[35][57]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][57]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][57]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][57]={1,3,17,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[47][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[48][57]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[50][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[56][57]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][57]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][57]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][57]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][57]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][57]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][57]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][57]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][57]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][57]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][57]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][57]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][57]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][57]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][57]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][57]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][57]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][57]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][57]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][57]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][57]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][57]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][57]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][57]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][57]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][57]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[93][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[98][57]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[99][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[1][58]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][58]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][58]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][58]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][58]={3,3,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[6][58]={4,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[7][58]={4,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[8][58]={9,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[9][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][58]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[11][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[12][58]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][58]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][58]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][58]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][58]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][58]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][58]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][58]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][58]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][58]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][58]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][58]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][58]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[25][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][58]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][58]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][58]={4,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[38][58]={4,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][58]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][58]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][58]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[53][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[54][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[57][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[60][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][58]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][58]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][58]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][58]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][58]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][58]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][58]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][58]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][58]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][58]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][58]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][58]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][58]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][58]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][58]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][58]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][58]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][58]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][58]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][58]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][58]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][58]={0,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][58]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[94][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[99][58]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][58]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][58]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[102][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][59]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[1][59]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][59]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][59]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][59]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][59]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][59]={4,-1,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[7][59]={4,-1,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[8][59]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][59]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[11][59]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][59]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][59]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][59]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][59]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][59]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][59]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][59]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][59]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][59]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][59]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][59]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][59]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[36][59]={10,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][59]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[47][59]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[50][59]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[51][59]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[56][59]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][59]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][59]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][59]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][59]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][59]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][59]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[67][59]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][59]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][59]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][59]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][59]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][59]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][59]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][59]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][59]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][59]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][59]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][59]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][59]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][59]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][59]={11,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[92][59]={3,3,5,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[93][59]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[94][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][59]={4,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[100][59]={4,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[101][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][60]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][60]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][60]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][60]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][60]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][60]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][60]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][60]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][60]={9,3,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[9][60]={9,3,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[10][60]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][60]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][60]={9,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][60]={9,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[14][60]={9,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[15][60]={9,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[16][60]={9,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[17][60]={9,-1,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[18][60]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][60]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][60]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][60]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][60]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][60]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][60]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][60]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[37][60]={10,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][60]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[39][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][60]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[45][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[48][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][60]={4,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][60]={3,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[53][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[57][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[59][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[60][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][60]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][60]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][60]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][60]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][60]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][60]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][60]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][60]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][60]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[84][60]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][60]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][60]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][60]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][60]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][60]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][60]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][60]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][60]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][60]={3,3,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[94][60]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[95][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][60]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][61]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][61]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][61]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][61]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][61]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][61]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][61]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][61]={10,3,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[10][61]={9,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[11][61]={9,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[12][61]={10,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][61]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][61]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][61]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][61]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][61]={12,-1,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[18][61]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][61]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][61]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[21][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][61]={14,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][61]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[27][61]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][61]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][61]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][61]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[37][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[38][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[39][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][61]={4,-1,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[44][61]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][61]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][61]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[47][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][61]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][61]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][61]={1,3,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[52][61]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[53][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][61]={0,5,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][61]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][61]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[58][61]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[59][61]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[62][61]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][61]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[64][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[65][61]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][61]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][61]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][61]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][61]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][61]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][61]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][61]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][61]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][61]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][61]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][61]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][61]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][61]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][61]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][61]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][61]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][61]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[84][61]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][61]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][61]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][61]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][61]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][61]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][61]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][61]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][61]={10,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][61]={4,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][61]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[95][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[99][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[100][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[103][61]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[0][62]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][62]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][62]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][62]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][62]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][62]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][62]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[8][62]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][62]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][62]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][62]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][62]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][62]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][62]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][62]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[16][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[17][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[21][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[22][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][62]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[26][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][62]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[28][62]={12,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][62]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][62]={10,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][62]={10,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][62]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[34][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][62]={10,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[39][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][62]={1,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[44][62]={4,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[45][62]={11,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][62]={4,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[47][62]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[49][62]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[50][62]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[51][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][62]={0,5,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[53][62]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][62]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][62]={0,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[57][62]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][62]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][62]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[61][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[63][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[65][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][62]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][62]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][62]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][62]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][62]={12,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][62]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][62]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][62]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][62]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][62]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][62]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][62]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][62]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][62]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][62]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][62]={9,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][62]={9,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][62]={10,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][62]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][62]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][62]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][62]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[98][62]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[99][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][62]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[0][63]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][63]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][63]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][63]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][63]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][63]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][63]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[7][63]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[8][63]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][63]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][63]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][63]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][63]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][63]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][63]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[25][63]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[26][63]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][63]={12,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][63]={12,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][63]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[30][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[31][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[32][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[43][63]={1,-1,17,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[44][63]={4,-1,17,{{1,5},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][63]={11,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][63]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][63]={1,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][63]={1,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][63]={0,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][63]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[51][63]={0,5,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][63]={1,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[53][63]={0,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[54][63]={3,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[55][63]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[56][63]={3,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[57][63]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][63]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][63]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][63]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][63]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][63]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][63]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[64][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[65][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[66][63]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][63]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][63]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][63]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][63]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][63]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][63]={12,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][63]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][63]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][63]={12,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][63]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][63]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][63]={12,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][63]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][63]={12,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][63]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][63]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][63]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][63]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][63]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][63]={9,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][63]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][63]={9,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][63]={10,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][63]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][63]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][63]={13,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][63]={10,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][63]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][63]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][63]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][63]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[99][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[101][63]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[102][63]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][63]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}

	return MapToConvert
end